function [ h ] = fct_hazard(t,mu,sigma)
% computes the hazard rate
%
% denominator of hazard rate
ht = fct_pdf_f(t,mu,sigma);
% numeratoor of hazar rate
hb = 1-fct_CDF_F_capped(t,mu,sigma);
% hazard rate
h = ht./hb;
% asymptotic expansion of hazard rate, based on L'Hopital type of logic
hl = (3/2)*t.^(-1) - (- 2*mu*(mu .* t - 1 ).*(2.*sigma.^2 .* t) + (mu .* t - 1 ).^2 * 2 .*sigma.^2  ) ./ ((2.*sigma.^2 .* t).^2) ;

% use asymptotic hazard rate when both numerator and denominator are small
% or when denominator is very small
for i=1:length(t);
    if (ht(i) < 1e-9) & (hb(i) < 1e-9) & (mu>0)
    h(i)=hl(i);
    elseif (hb(i) < 1e-30) & (mu>0)
    h(i)=hl(i);
    elseif (ht(i) < 1e-9) & (hb(i) < 1e-9) & (mu<0)
    h(i)=0;
    end
end

end

